/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8271c;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8271c.BoxInfo;
import ibm.nways.jdm8271c.NlsConstants;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class ResPairModify
implements JDMWizardPanelDelegate {
    private static final int RASID = 19;
    private static final int RASSUB = 10;
    protected DestinationPropBook myBook;
    protected JdmBrowser browser;
    NavigationContext myContext;
    GenModel model;
    GenModel portsModel;
    BoxInfo boxinfo;
    Integer Vlan;
    Integer MainUnit;
    Integer MainPort;
    Integer StandbyUnit;
    Integer StandbyPort;

    protected void finalize() {
    }

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        jDMWizardInfo.getModel();
        ModelInfo modelInfo = jDMWizardInfo.getCurrentRow();
        Hashtable hashtable = jDMWizardInfo.getItems();
        if (modelInfo != null) {
            this.Vlan = (Integer)modelInfo.get("Panel.ResRepeater");
            this.MainUnit = (Integer)modelInfo.get("Panel.ResMainSlot");
            this.MainPort = (Integer)modelInfo.get("Panel.ResMainPort");
            this.StandbyUnit = (Integer)modelInfo.get("Panel.ResStandbySlot");
            this.StandbyPort = (Integer)modelInfo.get("Panel.ResStandbyPort");
            hashtable.put("modifyMainSlot", this.MainUnit);
            hashtable.put("modifyMainPort", this.MainPort);
            hashtable.put("modifyMainState", modelInfo.get("Panel.ResMainState"));
            hashtable.put("modifyStandbySlot", this.StandbyUnit);
            hashtable.put("modifyStandbyPort", this.StandbyPort);
            hashtable.put("modifyStandbyState", modelInfo.get("Panel.ResStandbyState"));
            hashtable.put("modifyTogglePort", new Integer(1));
            hashtable.put("modifygo", new Boolean(true));
            this.displayMsg(ResPairModify.getNLSString("RL_modifyConfirm"));
            return;
        }
        hashtable.put("modifyMainSlot", " ");
        hashtable.put("modifyMainPort", " ");
        hashtable.put("modifyMainState", " ");
        hashtable.put("modifyStandbySlot", " ");
        hashtable.put("modifyStandbyPort", " ");
        hashtable.put("modifyStandbyState", " ");
        hashtable.put("modifyTogglePort", new Integer(1));
        hashtable.put("modifygo", new Boolean(false));
        this.displayMsg(ResPairModify.getNLSString("RL_NodeleteConfirm"));
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        this.displayMsg(ResPairModify.getNLSString("RL_modifyAbort"));
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        boolean bl = false;
        String string = "RL_modifyError";
        String string2 = "proceed";
        GenModel genModel = jDMWizardInfo.getModel();
        ModelInfo modelInfo = null;
        Hashtable hashtable = jDMWizardInfo.getItems();
        boolean bl2 = (Boolean)hashtable.get("modifygo");
        Integer n = (Integer)hashtable.get("modifyStandbySlot");
        Integer n2 = (Integer)hashtable.get("modifyStandbyPort");
        Integer n3 = (Integer)hashtable.get("modifyTogglePort");
        if (n.equals(this.StandbyUnit) && n2.equals(this.StandbyPort) && n3 == 1) {
            string = "RL_NoModifyError";
            bl2 = false;
        }
        int n4 = 1;
        while (n4 <= 3 && bl2) {
            modelInfo = new ModelInfo();
            modelInfo.add("Index.ResRepeater", this.Vlan);
            modelInfo.add("Index.ResMainSlot", this.MainUnit);
            modelInfo.add("Index.ResMainPort", this.MainPort);
            switch (n4) {
                case 1: {
                    modelInfo.add("Panel.ResPairModificationStatus", new Integer(1));
                    break;
                }
                case 2: {
                    if (!n.equals(this.StandbyUnit) || !n2.equals(this.StandbyPort)) {
                        modelInfo.add("Panel.ResStandbySlot", n);
                        modelInfo.add("Panel.ResStandbyPort", n2);
                        break;
                    }
                    modelInfo.add("Panel.ResPairAction", new Integer(3));
                    break;
                }
                case 3: {
                    modelInfo.add("Panel.ResPairModificationStatus", new Integer(2));
                    break;
                }
            }
            try {
                if (RAS.isEnabled(19, 10)) {
                    RAS.trace(19, 10, this, string2, "Before Set Number " + n4 + " ModelInfo = " + modelInfo.toString());
                }
                modelInfo = genModel.setInfo("Panel", modelInfo);
                Enumeration enumeration = modelInfo.getItemIds();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    Serializable serializable = modelInfo.get(string3);
                    if (!(serializable instanceof SpecialValue)) continue;
                    bl2 = false;
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl2 = false;
                RAS.logException(19, 10, this, string2, exception);
            }
            ++n4;
        }
        if (bl2) {
            this.displayMsg(ResPairModify.getNLSString("RL_modifyOK"));
        } else {
            this.displayMsg(ResPairModify.getNLSString(string));
            MessageBox messageBox = new MessageBox(this.browser.getFrame(), ResPairModify.getNLSString("RL_error"), ResPairModify.getNLSString(string), true);
        }
        return bl2;
    }

    protected void displayMsg(String string) {
        if (this.browser != null) {
            this.browser.displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = NlsConstants.my8271cBundle.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }
}

